async function getCurrentTab() {
    const queryOptions = { active: true, currentWindow: true };
    const [tab] = await chrome.tabs.query(queryOptions);
    return tab;
}
async function readPage() {
    async function fetchAndConvertBlob(blobUrl) {
        try {
            const response = await fetch(blobUrl);
            const blob = await response.blob();
            return blob;
        } catch (error) {
            console.error("Error fetching the blob:", error);
        }
    }

    function getHostnameWithoutExtension(url) {
        try {
            const hostname = new URL(url).hostname; // Extracts the hostname from the URL
            const parts = hostname.split('.'); // Splits the hostname into parts
            if (parts.length > 2) {
                // Removes subdomains if they exist (e.g., "www.")
                return parts.slice(parts.length - 2, parts.length - 1)[0];
            } else {
                // No subdomains, just remove the top-level domain
                return parts[0];
            }
        } catch (error) {
            console.error("Invalid URL:", error.message);
            return null;
        }
    }
    async function getPDFLink(host){
        let isPDFView = false;
        if (host === 'google' || host === 'gmail'){ // Google
            isPDFView = document.getElementById('drive-active-item-info')
            if (isPDFView)
                return document.querySelector('span[download_url]').querySelector('a').getAttribute('href')
        }
        if (host === 'proton' || host === 'protonmail'){ // Proton
            const objectList = document.getElementsByTagName('object')
            for (var i = 0; i < objectList.length; i++){
                const el = objectList[i]
                if (el['type'] === 'application/pdf'){
                    const bolb = await fetchAndConvertBlob(el['data']);
                    return URL.createObjectURL(bolb);
                }
            }

        }
    }
    function getBody() {
        console.error("Reading body")
        const res = [document.body.innerHTML]
        const frames = document.getElementsByTagName("iframe");
        for (let i = 0; i < frames.length; ++i) {
            console.error("Frame iterator" + i)
            const iframe = frames[i]
            console.error(iframe)
            try{
                const iframeDocument = iframe.contentDocument || iframe.contentWindow.document
                res.push(iframeDocument.body.innerHTML);

            } catch(e){
                console.log("Some frames have no contents?")
            }
            console.error("Frame iterator" + i)

        }
        console.error("Finished body")
        return res
    }
    const host = getHostnameWithoutExtension(document.location.origin);
    const pdf_link = await getPDFLink(host);
    const body = getBody()
    /// starting here new stage
    /// end of new stage
    console.log("Final output")
    console.log([body, pdf_link, host])
    return [body, pdf_link, host];
//    return [iframeContent, pdf_link, host];
}

function sendToQuotomate(trans, html_body, download_file, host){
    const requestData = {
        trans: trans,
        html_body: JSON.stringify(html_body),
        download_file,
        host
    };
    fetch('http://localhost:5001', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify(requestData),
    })
        .then(response => {
            document.body.style.backgroundColor = 'green';
            if (!response.ok) {
                throw new Error(`HTTP error! Status: ${response.status}`);
            }
            return response.json();
        })
        .then(data => {
            console.log('Response:', data);
        })
        .catch(error => {
            console.error('Error:', error);
        });
}
async function clickHandler(trans){
    const tab = await getCurrentTab();

    chrome.scripting.executeScript({
        target: { tabId: tab.id },
        func: readPage
    },async function(res) {
        const html_body = res[0].result[0]
        const pdfLink = res[0].result[1]
        const host = res[0].result[2]
        if (pdfLink){
            chrome.downloads.onDeterminingFilename.addListener(
                function(file){
                    sendToQuotomate(trans, html_body, file.filename, host)
                },
            )
            chrome.downloads.onCreated.addListener(
                function(file){
            })
            chrome.downloads.download({
            url: pdfLink,
            filename: "example.pdf"
        },function(res){
            });
        } else {
            sendToQuotomate(trans, html_body, undefined, host)
        }
    });
}
const rfqButton = document.getElementById("rfqBtn");
const quoteButton = document.getElementById("quoteBtn");
const opoButton = document.getElementById("opoBtn");
const partsBaseBasketButton = document.getElementById("partsbaseBasketBtn")
rfqButton.addEventListener("click", async function(){
    await clickHandler('rfq')
});

quoteButton.addEventListener("click", async function(){
    await clickHandler('batch')
});

opoButton.addEventListener("click", async function(){
    await clickHandler('opo')
});

partsBaseBasketButton.addEventListener("click", async function(){
    await clickHandler('partsbaseBasket')
});
